/*
 * Decompiled with CFR 0.152.
 */
package update;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;
import update.IFileDownload;
import update.LocalFilesManager;

public class HpoFileDownloader
implements IFileDownload {
    private String fileAddress;
    private String downloadFolder;
    private String formatVersion;
    private Date releaseDate;

    public HpoFileDownloader(String fileAddress, String downloadFolder) {
        this.fileAddress = fileAddress;
        this.downloadFolder = downloadFolder;
    }

    private static boolean isHpoTerm(String id) {
        return id.matches("^HP:\\d{7}$");
    }

    @Override
    public void downloadFile(String fileName) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(this.fileAddress).openStream()));
             BufferedWriter writer = new BufferedWriter(new FileWriter(this.downloadFolder + fileName));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("format-version")) {
                    this.formatVersion = line;
                }
                if (line.startsWith("data-version:")) {
                    String[] tokens = line.split("/");
                    this.releaseDate = LocalFilesManager.convertStringToDate(line.split(":")[1], "yyyy-MM-dd");
                }
                writer.write(line);
                writer.newLine();
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public String getFileAddress() {
        return this.fileAddress;
    }

    public void setFileAddress(String fileAddress) {
        this.fileAddress = fileAddress;
    }

    public String getDownloadFolder() {
        return this.downloadFolder;
    }

    @Override
    public String getFormatVersion() {
        return this.formatVersion;
    }

    public void setDownloadFolder(String downloadFolder) {
        this.downloadFolder = downloadFolder;
    }

    @Override
    public Date getReleaseDate() {
        return this.releaseDate;
    }
}

