/*
 * Decompiled with CFR 0.152.
 */
package update;

import configurator.Configurator;
import hugo.HUGOFlatFileCreator;
import hugo.HUGOXmlDownloader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import propagation.OboParser;
import propagation.Propagation;
import update.FtpConnection;
import update.GOFileDownloader;
import update.HpoFileDownloader;
import update.IFileDownload;
import update.LocalFilesManager;
import update.UniProtFileDownloader;

public final class DiNGOFilesUpdater {
    private final Configurator configurator;
    private IFileDownload fileDownloader;
    private final String speciesName;

    private DiNGOFilesUpdater(String speciesName) {
        this.speciesName = speciesName;
        this.configurator = new Configurator(speciesName);
    }

    private static boolean compareDate(Date oldDate, Date newDate) {
        if (oldDate == null) {
            return true;
        }
        return newDate.compareTo(oldDate) > 0;
    }

    private static boolean replaceFile(String source, String target) {
        boolean success = true;
        try {
            Files.move(Paths.get(source, new String[0]), Paths.get(target, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            success = false;
        }
        return success;
    }

    private boolean addNamespacesToObo(String oboFile) {
        try {
            Class.forName("propagation.Propagation");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DiNGOFilesUpdater.class.getName()).log(Level.WARNING, null, ex);
            return false;
        }
        OboParser oboParser = new OboParser(oboFile);
        System.out.println("Reading " + oboFile);
        Propagation propagation = new Propagation(oboParser);
        System.out.println("Reading done!\nFound " + oboParser.getLeafTerms().size() + " leaf terms");
        System.out.println("Propagating leaf terms...");
        return propagation.addNamespaceInfoToOboFile(this.configurator.getDownloadFolder() + this.configurator.getHpoOntologyFileName());
    }

    private void updateGOFile(String fileName) {
        String dingoFilesFolder = this.configurator.getDirFiles();
        String downloadFolder = this.configurator.getDownloadFolder();
        String link = this.configurator.getGoConsortiumAddress();
        String serverFolder = fileName.endsWith(".obo") ? this.configurator.getPathToOboFile() : this.configurator.getPathToAnnotationFile();
        String fileAddress = link + serverFolder + fileName;
        System.out.println("Downloading " + fileName + " from " + link);
        this.fileDownloader = new GOFileDownloader(fileAddress, downloadFolder);
        if (fileName.endsWith(".gz")) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        ProgressBar pBar = new ProgressBar();
        pBar.start();
        this.fileDownloader.downloadFile(fileName);
        pBar.setShowProgressBar(false);
        Date lastModDate = this.fileDownloader.getReleaseDate();
        Date currentFileDate = LocalFilesManager.extractOboReleaseDate(dingoFilesFolder + fileName);
        if (currentFileDate != null) {
            System.out.println("Releasing date of current file located at " + dingoFilesFolder + ": " + String.valueOf(currentFileDate));
        }
        System.out.println("Releasing date of downloaded file located at " + downloadFolder + ": " + String.valueOf(lastModDate));
        if (DiNGOFilesUpdater.compareDate(currentFileDate, lastModDate)) {
            if (DiNGOFilesUpdater.replaceFile(downloadFolder + fileName, dingoFilesFolder + fileName)) {
                System.out.println("File " + this.configurator.getDirFiles() + fileName + " has been successfully updated!");
            } else {
                System.out.println("File " + this.configurator.getDownloadFolder() + fileName + " can't be moved to " + this.configurator.getDirFiles() + " Try moving the file manually.");
            }
        } else {
            System.out.println("File is up-to-date!");
        }
    }

    private void updateGOOboFile() {
        this.updateGOFile(this.configurator.getGoOntologyFileName());
    }

    private void updateGafFile() {
        boolean isFileExists = true;
        String annotationFileName = this.configurator.getAnnotationFileName();
        if (annotationFileName == null) {
            System.out.println("Can't find annotation file for species " + this.speciesName);
            isFileExists = false;
        }
        if (isFileExists) {
            this.updateGOFile(annotationFileName);
        }
    }

    private void updateUniProtMappingFile() {
        String uniProtFtpAddress = this.configurator.getUniProtFtpAddress();
        String pathToUniProtFiles = this.configurator.getUniProtByOrganismFolder();
        String downloadFolder = this.configurator.getMappingFolder();
        String mappingFileName = this.configurator.getUniProtMappingFileName();
        boolean isFileExist = true;
        if (mappingFileName == null) {
            System.out.println("Can't find idmapping.dat file for species " + this.speciesName);
            isFileExist = false;
        }
        if (isFileExist) {
            FtpConnection connection = FtpConnection.getInstance(uniProtFtpAddress, this.configurator.getUserName(), this.configurator.getPassword(), this.configurator.getPort());
            this.fileDownloader = new UniProtFileDownloader(connection, uniProtFtpAddress, pathToUniProtFiles, downloadFolder);
            ProgressBar pBar = new ProgressBar();
            pBar.start();
            this.fileDownloader.downloadFile(mappingFileName);
            pBar.setShowProgressBar(false);
        }
    }

    private void updateSwissProtFastaFile() {
        String uniProtFtpAddress = this.configurator.getUniProtFtpAddress();
        String pathToUniProtFiles = this.configurator.getUniprotSwissFastFileFolder();
        String downloadFolder = this.configurator.getMappingFolder();
        String fileName = "uniprot_sprot.fasta.gz";
        FtpConnection connection = FtpConnection.getInstance(uniProtFtpAddress, this.configurator.getUserName(), this.configurator.getPassword(), this.configurator.getPort());
        this.fileDownloader = new UniProtFileDownloader(connection, uniProtFtpAddress, pathToUniProtFiles, downloadFolder);
        ProgressBar pBar = new ProgressBar();
        pBar.start();
        this.fileDownloader.downloadFile(fileName);
        pBar.setShowProgressBar(false);
    }

    private void updateGOFiles() {
        this.updateGOOboFile();
        this.updateGafFile();
    }

    private void updateHPOboFile() {
        String oboFile = "hp.obo";
        String address = this.configurator.getHpOboAddress();
        String dataFolder = this.configurator.getDirFiles();
        String downloadFolder = this.configurator.getDownloadFolder();
        String currentOboFile = this.configurator.getHpoOntologyFileName();
        this.fileDownloader = new HpoFileDownloader(address, downloadFolder);
        System.out.println("Downloading " + oboFile + " from " + address);
        ProgressBar pBar = new ProgressBar();
        pBar.start();
        this.fileDownloader.downloadFile(oboFile);
        pBar.setShowProgressBar(false);
        Date currentOborelease = LocalFilesManager.extractOboReleaseDate(dataFolder + currentOboFile);
        Date newOboRelease = this.fileDownloader.getReleaseDate();
        if (currentOborelease != null) {
            System.out.println("Releasing date of current file located at " + dataFolder + ": " + String.valueOf(currentOborelease));
        }
        System.out.println("Releasing date of downloaded file located at " + downloadFolder + ": " + String.valueOf(newOboRelease));
        boolean isObsolete = DiNGOFilesUpdater.compareDate(currentOborelease, newOboRelease);
        if (isObsolete) {
            boolean isUpdated;
            boolean isNamespaceAdded = this.addNamespacesToObo(this.configurator.getDownloadFolder() + oboFile);
            if (!isNamespaceAdded) {
                LocalFilesManager.renameFile(this.configurator.getDownloadFolder() + oboFile, this.configurator.getDownloadFolder() + this.configurator.getHpoOntologyFileName());
            }
            if (isUpdated = DiNGOFilesUpdater.replaceFile(this.configurator.getDownloadFolder() + this.configurator.getHpoOntologyFileName(), this.configurator.getDirFiles() + this.configurator.getHpoOntologyFileName())) {
                System.out.println("File " + this.configurator.getDirFiles() + this.configurator.getHpoOntologyFileName() + " has been successfully updated!");
            } else {
                System.out.println("File " + this.configurator.getDownloadFolder() + this.configurator.getHpoOntologyFileName() + " can't be moved to " + this.configurator.getDirFiles());
            }
        }
    }

    private void updateHPAnnotationFile() {
        System.out.println("Can't update HPO annotation file, please download manually necessary files and create HPO annotation file using hpoannotation module. For more info see README file.");
    }

    private void updateHPOFiles() {
        this.updateHPOboFile();
        this.updateHPAnnotationFile();
    }

    private void updateHUGOFile() {
        String link = this.configurator.getHugoFileAddress();
        String fileName = this.configurator.getMappingFolder() + "hugo_mapping_id.xml";
        System.out.println("Downloading HUGO XML file from " + link);
        System.out.println("This may take a while...");
        ProgressBar pBar = new ProgressBar();
        pBar.start();
        HUGOXmlDownloader downloader = new HUGOXmlDownloader(link, fileName);
        pBar.setShowProgressBar(false);
        boolean success = downloader.downloadHUGOFile();
        if (success) {
            System.out.println("Parsing " + fileName);
            HUGOFlatFileCreator test = new HUGOFlatFileCreator(fileName);
            test.createFlatFile(this.configurator.getMappingFolder() + "ids_mapping.tab");
            System.out.println("Done!");
        }
    }

    public static void main(String[] args) {
        if (args.length <= 1) {
            System.out.println("Description:");
            System.out.println("DiNGOFilesUpdater downloads GO, HPO, HUGO and UniProt mapping files \nand updates DiNGO default files.");
            System.out.println("Usage:");
            System.out.println("update -f <file type> -sp <species|namespace> -d <files to update>\n");
            System.out.println("Options:");
            System.out.printf("%-27s%s\n", "-f <file type>", "GO GO files");
            System.out.printf("%-27s%s\n", "              ", "HPO HPO files");
            System.out.printf("%-27s%s\n", "              ", "HUGO HUGO id mapping file");
            System.out.printf("%-27s%s\n", "              ", "UniProt UniProt id mapping file");
            System.out.printf("%-27s%s\n", "              ", "SwissProt contains fasta sequences of manually reviewed UniProt entries");
            System.out.printf("%-27s%s\n", "-sp <species|namespace>", "species for GO [default: human]");
            System.out.printf("%-27s%s\n", "                       ", "namespace for HPO [default: W]");
            System.out.printf("%-27s%s\n", "                       ", "species for UniProt [default: human]");
            System.out.printf("%-27s%s\n", "-d <files to update>", "1 update OBO file");
            System.out.printf("%-27s%s\n", "                    ", "2 update annotation file");
            System.out.printf("%-27s%s\n", "                    ", "3 update OBO and annotation file");
            return;
        }
        if (!args[0].equals("update")) {
            System.out.println("The first argument must be update.");
            System.out.println("Unknown command: " + args[0]);
            return;
        }
        Configurator conf = new Configurator();
        conf.createDiNGOFolders();
        String fileType = "";
        String attribute = "";
        String dValue = "3";
        int len = args.length;
        for (int i = 1; i < len - 1; ++i) {
            if (args[i].equals("-f")) {
                fileType = args[i + 1];
            }
            if (args[i].equals("-sp")) {
                attribute = args[i + 1];
            }
            if (!args[i].equals("-d")) continue;
            dValue = args[i + 1];
        }
        if (fileType.equalsIgnoreCase("GO")) {
            if (attribute.isEmpty()) {
                attribute = "human";
            }
            DiNGOFilesUpdater filesUpdater = new DiNGOFilesUpdater(attribute);
            switch (dValue) {
                case "1": {
                    filesUpdater.updateGOOboFile();
                    break;
                }
                case "2": {
                    filesUpdater.updateGafFile();
                    break;
                }
                case "3": {
                    filesUpdater.updateGOFiles();
                    break;
                }
                default: {
                    System.out.println("Unknown argument " + dValue);
                    break;
                }
            }
        } else if (fileType.equalsIgnoreCase("HPO")) {
            DiNGOFilesUpdater filesUpdater = new DiNGOFilesUpdater("human");
            switch (dValue) {
                case "1": {
                    filesUpdater.updateHPOboFile();
                    break;
                }
                case "2": {
                    filesUpdater.updateHPAnnotationFile();
                    break;
                }
                case "3": {
                    filesUpdater.updateHPOFiles();
                    break;
                }
                default: {
                    System.out.println("Unknown argument " + dValue);
                    break;
                }
            }
        } else if (fileType.equalsIgnoreCase("HUGO")) {
            DiNGOFilesUpdater filesUpdater = new DiNGOFilesUpdater("human");
            filesUpdater.updateHUGOFile();
        } else if (fileType.equalsIgnoreCase("UniProt")) {
            if (attribute.isEmpty()) {
                attribute = "human";
            }
            DiNGOFilesUpdater filesUpdater = new DiNGOFilesUpdater(attribute);
            filesUpdater.updateUniProtMappingFile();
        } else if (fileType.equalsIgnoreCase("SwissProt")) {
            DiNGOFilesUpdater filesUpdater = new DiNGOFilesUpdater(attribute);
            filesUpdater.updateSwissProtFastaFile();
        } else {
            System.out.println("Available files to update:");
            System.out.println("1. GO\n2. HPO\n3. HUGO\n4. SwissProt\n5. UniProt");
            System.out.println("Unknown file type: " + fileType);
        }
    }

    private class ProgressBar
    extends Thread {
        private boolean showProgressBar = true;

        private ProgressBar() {
        }

        @Override
        public void run() {
            String label = "Downloading";
            while (this.showProgressBar) {
                String anim = "|/-\\";
                for (int x = 0; x < anim.length(); ++x) {
                    char data = anim.charAt(x);
                    try {
                        System.out.print(label + " " + data + "\r");
                        Thread.sleep(75L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(ProgressBar.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            System.out.println("                   ");
        }

        public boolean isShowProgressBar() {
            return this.showProgressBar;
        }

        public void setShowProgressBar(boolean showProgressBar) {
            this.showProgressBar = showProgressBar;
        }
    }
}

