/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import propagation.OboParser;
import propagation.Term;

public class Propagation {
    private String namespace = "";
    private final Map<Term, List<Term>> termToParents = new HashMap<Term, List<Term>>();
    private final OboParser oboParser;

    public Propagation(OboParser oboParser) {
        this.oboParser = oboParser;
    }

    private void initTemToParentsMap() {
        List<Term> terms = this.oboParser.getAllTerms();
        for (Term t : terms) {
            try {
                List<Term> temp1 = t.getParentTerms();
                this.termToParents.put(t, temp1);
            }
            catch (NullPointerException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    public List<Term> propagateTerm(Term term) {
        if (this.termToParents.isEmpty()) {
            this.initTemToParentsMap();
        }
        HashSet<Term> props = new HashSet<Term>();
        ArrayList<Term> terms = new ArrayList<Term>();
        ArrayList tempList = new ArrayList();
        terms.add(term);
        while (!terms.isEmpty()) {
            for (Term t : terms) {
                if (this.termToParents.containsKey(t)) {
                    if (this.termToParents.get(t).isEmpty()) break;
                    if (this.termToParents.get(t).size() == 1 && this.termToParents.get(this.termToParents.get(t).get(0)).isEmpty()) {
                        this.namespace = t.getName().toLowerCase().replace(" ", "_");
                    }
                    tempList.addAll(this.termToParents.get(t));
                    props.add(t);
                    continue;
                }
                System.out.println("Term " + t.getId() + " not found!");
                return terms;
            }
            terms = new ArrayList(tempList);
            tempList.clear();
        }
        return new ArrayList<Term>(props);
    }

    private Map<Term, String> mapTermToNamespace() {
        HashMap<Term, String> namespaces = new HashMap<Term, String>();
        List<Term> leafTerms = this.oboParser.getLeafTerms();
        for (Term t : leafTerms) {
            List<Term> props = this.propagateTerm(t);
            if (props.size() <= 1) continue;
            for (Term p : props) {
                namespaces.put(p, this.namespace);
            }
        }
        return namespaces;
    }

    public boolean addNamespaceInfoToOboFile(String oboFile) {
        String oldObo = this.oboParser.getFileName();
        System.out.println("Adding namespace info to OBO file...");
        try (BufferedReader reader = new BufferedReader(new FileReader(oldObo));
             BufferedWriter writer = new BufferedWriter(new FileWriter(oboFile));){
            String line;
            Map<Term, String> termToNamespace = this.mapTermToNamespace();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("id: HP")) {
                    writer.write(line);
                    writer.newLine();
                    if (!termToNamespace.containsKey(new Term(line.split(":")[2], ""))) continue;
                    writer.write("namespace: " + termToNamespace.get(new Term(line.split(":")[2], "")));
                    writer.newLine();
                    continue;
                }
                writer.write(line);
                writer.newLine();
            }
            System.out.println("Done!");
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("java Propagation -i <input HPO obo file> -o <output OBO file>");
            return;
        }
        String iFile = "";
        String oFile = "";
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i].equals("-i")) {
                iFile = args[i + 1];
                continue;
            }
            if (!args[i].equals("-o")) continue;
            oFile = args[i + 1];
        }
        if (iFile.isEmpty()) {
            System.out.println("Please specify HPO OBO file!");
            return;
        }
        Propagation test = new Propagation(new OboParser(iFile));
        test.addNamespaceInfoToOboFile(oFile);
    }
}

