/*
 * Decompiled with CFR 0.152.
 */
package hugo;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class HUGOFlatFileCreator {
    private final String xmlFile;

    public HUGOFlatFileCreator(String xmlFile) {
        this.xmlFile = xmlFile;
    }

    public void createFlatFile(String outFile) {
        try {
            PrintWriter writer = new PrintWriter(outFile);
            File hugoFile = new File(this.xmlFile);
            SAXBuilder saxb = new SAXBuilder();
            Document document = saxb.build(hugoFile);
            Element element = document.getRootElement();
            List<Element> elements = element.getChildren("result");
            if (elements == null) {
                System.out.println("No elements found!!");
                return;
            }
            for (int i = 0; i < elements.size(); ++i) {
                List<Element> docs = elements.get(i).getChildren("doc");
                for (Element doc : docs) {
                    List<Element> ids = doc.getChildren();
                    for (Element id : ids) {
                        if (id.getAttributeValue("name").equals("symbol")) {
                            writer.print(id.getText() + "\t");
                        }
                        if (id.getAttributeValue("name").equals("hgnc_id")) {
                            writer.print(id.getText() + "\t");
                        }
                        if (id.getAttributeValue("name").equals("alias_symbol")) {
                            List<Element> aliasList = id.getChildren("str");
                            for (Element a : aliasList) {
                                writer.print(a.getText() + "\t");
                            }
                        }
                        if (id.getAttributeValue("name").equals("entrez_id")) {
                            writer.print(id.getText() + "\t");
                        }
                        if (id.getAttributeValue("name").equals("prev_symbol")) {
                            List<Element> prevList = id.getChildren("str");
                            for (Element p : prevList) {
                                writer.print(p.getText() + "\t");
                            }
                        }
                        if (!id.getAttributeValue("name").equals("uniprot_ids")) continue;
                        List<Element> uniprotList = id.getChildren("str");
                        for (Element unip : uniprotList) {
                            writer.print(unip.getText() + "\t");
                        }
                    }
                    writer.println();
                }
            }
            writer.close();
        }
        catch (IOException | JDOMException ex) {
            Logger.getLogger(HUGOFlatFileCreator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

