/*
 * Decompiled with CFR 0.152.
 */
package hpoannotation;

import hpoannotation.HpoOntology;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;

public class HpoFlatAnnotationWriter {
    private final String annotationFileName;
    private String hpOntology;
    private final Map<String, String> termToSubontology;

    public HpoFlatAnnotationWriter(HpoOntology hpoOntology, Map<String, String> termToSubontology) {
        this.hpOntology = hpoOntology.toString().toLowerCase();
        this.annotationFileName = "hpo_" + this.hpOntology + ".txt";
        this.termToSubontology = termToSubontology;
    }

    private String getOntologySymbol() {
        return switch (this.hpOntology) {
            case "phenotypic_abnormality" -> "P";
            case "mode_of_inheritance" -> "I";
            case "clinical_course" -> "C";
            case "clinical_modifier" -> "M";
            default -> "W";
        };
    }

    private String header() {
        return String.format("(species=Homo Sapiens)(type=%s)(curator=HPO)", this.hpOntology);
    }

    private void writeLineToFile(String line, BufferedWriter writer) throws IOException {
        if (this.termToSubontology == null || this.termToSubontology.isEmpty()) {
            return;
        }
        String ontSymbol = this.getOntologySymbol();
        if (!line.startsWith("ncbi")) {
            String[] tokens = line.split("\\t");
            if (this.termToSubontology.containsKey(tokens[2]) && (this.termToSubontology.get(tokens[2]).equals(ontSymbol) || ontSymbol.equals("W")) && !tokens[1].equals("-")) {
                writer.write(tokens[1] + "=" + tokens[2].split(":")[1]);
                writer.newLine();
            }
        } else {
            writer.write(this.header());
            writer.newLine();
        }
    }

    public void writerAnnotationFile(String geneToPhenotypeFile) {
        try (BufferedReader reader = new BufferedReader(new FileReader(geneToPhenotypeFile));
             BufferedWriter writer = new BufferedWriter(new FileWriter(this.annotationFileName));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.writeLineToFile(line, writer);
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
    }
}

