/*
 * Decompiled with CFR 0.152.
 */
package hpoannotation;

import hpoannotation.HpoAnnotationReader;
import hpoannotation.HpoFlatAnnotationWriter;
import hpoannotation.HpoOntology;
import java.io.File;
import java.util.Arrays;
import java.util.Map;

public class HpoFlatAnnotationCreator {
    private static HpoOntology stringToEnum(String hpoOntology) {
        return switch (hpoOntology) {
            case "P" -> HpoOntology.PHENOTYPIC_ABNORMALITY;
            case "C" -> HpoOntology.CLINICAL_COURSE;
            case "I" -> HpoOntology.MODE_OF_INHERITANCE;
            case "M" -> HpoOntology.CLINICAL_MODIFIER;
            case "W" -> HpoOntology.ALL_SUBONTOLOGIES;
            default -> throw new IllegalArgumentException("Unknown hpo subontology");
        };
    }

    private static boolean checkIfElementExists(String[] arr, String element) {
        if (arr == null || arr.length == 0) {
            return false;
        }
        return Arrays.asList(arr).contains(element);
    }

    public static void main(String[] args) {
        HpoOntology hpoOntology;
        if (args.length < 3 || HpoFlatAnnotationCreator.checkIfElementExists(args, "-h")) {
            System.out.println("Usage:\n");
            System.out.println("-a <hpo annotation file> -g <genes to phenotypes file> -s <hpo subontology> \n");
            System.out.println("Options:\n");
            System.out.println("-a, hpo annotation file in hpoa format");
            System.out.println("-g, genes_to_disease.txt file");
            System.out.println("-s, hpo subontology. \nPossible values:\n1. P = phenotypic abnormality\n2. C = clinical course\n3. I = mode of inheritance\n4. M = clinical modifier\n5. W = all subontologies (default value)");
            return;
        }
        String annotationFile = "";
        String genesToPhenotypesFile = "";
        String subontology = "W";
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i].equals("-a")) {
                annotationFile = args[i + 1];
                continue;
            }
            if (args[i].equals("-g")) {
                genesToPhenotypesFile = args[i + 1];
                continue;
            }
            if (!args[i].equals("-s")) continue;
            subontology = args[i + 1];
        }
        File aFile = new File(annotationFile);
        if (!aFile.exists()) {
            System.out.println("Can't find file " + String.valueOf(aFile));
            return;
        }
        File gFile = new File(genesToPhenotypesFile);
        if (!gFile.exists()) {
            System.out.println("Can't find file " + String.valueOf(aFile));
            return;
        }
        try {
            hpoOntology = HpoFlatAnnotationCreator.stringToEnum(subontology);
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex.getMessage());
            return;
        }
        HpoAnnotationReader annotationReader = new HpoAnnotationReader(annotationFile);
        Map<String, String> termsMap = annotationReader.mapTermToSubontology();
        HpoFlatAnnotationWriter annotationWriter = new HpoFlatAnnotationWriter(hpoOntology, termsMap);
        annotationWriter.writerAnnotationFile(genesToPhenotypesFile);
    }
}

