/*
 * Decompiled with CFR 0.152.
 */
package dingo;

import bingo.AnnotationParser;
import bingo.BingoParameters;
import bingo.BingoRunner;
import bingo.StatisticsDescriptor;
import configurator.Configurator;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import update.DiNGOFilesUpdater;

public final class Dingo {
    private static String[] getDataSets(String text) {
        return text.split("batch");
    }

    private static void displayDiNGOParameters(BingoParameters params) {
        System.out.printf("%-30s%s%n", "Ontology:", params.getOntologyName());
        System.out.printf("%-30s%s%n", "Statistical test: ", params.getTest());
        System.out.printf("%-30s%s%n", "Correction: ", params.getCorrectionTest());
        System.out.printf("%-30s%s%n", "Significance: ", params.getSignificance());
        System.out.printf("%-30s%s%n", "Namespace: ", params.getNameSpace());
        System.out.printf("%-30s%s%n", "Representation: ", params.getOverOrUnder());
        System.out.printf("%-30s%s%n", "Reference set: ", params.getReferenceSet());
        System.out.printf("%-30s%s%n", "Species: ", params.getSpecies());
        System.out.printf("%-30s%s%n%n", "Discarded evidence code: ", params.getDeleteCodes());
    }

    private AnnotationParser getAnnotationParser(BingoParameters params) {
        HashSet<String> genes = new HashSet<String>();
        AnnotationParser annParser = new AnnotationParser(genes, params.getDeleteCodes(), params.getOntologyFile(), params.getAnnotationFile(), params.getNameSpace(), params.getMappingFile());
        if (annParser.getStatus()) {
            try {
                annParser.calculate();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                return null;
            }
        }
        return annParser;
    }

    private StatisticsDescriptor getStatisticsDescriptor(BingoParameters params) {
        StatisticsDescriptor descriptor = new StatisticsDescriptor();
        descriptor.setTest(params.getTest());
        descriptor.setCorrectionTest(params.getCorrectionTest());
        descriptor.setRepresentation(params.getOverOrUnder());
        descriptor.setpValue(params.getSignificance().toString());
        descriptor.setReferenceSet(params.getReferenceSet());
        return descriptor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        Configurator config;
        BingoParameters params;
        Instant start = Instant.now();
        if (args == null || args.length == 0 || args[0].equals("-h")) {
            BingoParameters.getHelp();
            System.exit(0);
        }
        Dingo sa = new Dingo();
        try {
            params = new BingoParameters(args);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            return;
        }
        String ontologyName = params.getOntologyName();
        Object ontologyFile = params.getOntologyFile();
        Object annotationFile = params.getAnnotationFile();
        String species = params.getSpecies();
        if (species == null || species.isEmpty()) {
            if (!ontologyName.equalsIgnoreCase("HPO")) {
                System.out.println("Species must be defined!");
                return;
            }
            species = "human";
            config = new Configurator(species);
        } else {
            config = new Configurator(species);
            if (!config.isSpeciesSupported(species)) {
                System.out.println("Species " + species + " is not supported!");
                return;
            }
        }
        config.createDiNGOFolders();
        if (ontologyName.equalsIgnoreCase("GO")) {
            if (annotationFile == null) {
                int ln;
                String fileString = config.getDirFiles() + config.getAnnotationFileName();
                annotationFile = fileString.substring(0, (ln = fileString.length()) - 3);
                if (!new File((String)annotationFile).exists()) {
                    DiNGOFilesUpdater.main(new String[]{"update", "-f", "GO", "-d", "2", "-sp", species});
                }
                params.setAnnotationFile((String)annotationFile);
            }
            if (ontologyFile == null) {
                ontologyFile = config.getDirFiles() + config.getGoOntologyFileName();
                if (!new File((String)ontologyFile).exists()) {
                    DiNGOFilesUpdater.main(new String[]{"update", "-f", "GO", "-d", "1", "-sp", species});
                }
                params.setOntologyFile((String)ontologyFile);
            }
        } else {
            if (!ontologyName.equalsIgnoreCase("HPO")) {
                System.out.println("Unknown ontology: " + ontologyName);
                return;
            }
            if (ontologyFile == null) {
                ontologyFile = config.getDirFiles() + config.getHpoOntologyFileName();
                if (!new File((String)ontologyFile).exists()) {
                    DiNGOFilesUpdater.main(new String[]{"update", "-f", "HPO", "-d", "1"});
                }
                params.setOntologyFile((String)ontologyFile);
            }
            if (annotationFile == null) {
                annotationFile = config.getDirFiles() + config.getHpoFullAnnotationFileName();
                if (!new File((String)annotationFile).exists()) {
                    DiNGOFilesUpdater.main(new String[]{"update", "-f", "HPO", "-d", "2"});
                    return;
                }
                params.setAnnotationFile((String)annotationFile);
            }
        }
        AnnotationParser annParser = sa.getAnnotationParser(params);
        StatisticsDescriptor descriptor = sa.getStatisticsDescriptor(params);
        String[] dataSets = Dingo.getDataSets(params.getTextInput());
        Dingo.displayDiNGOParameters(params);
        int numThreads = params.getNumberOfUsedCores();
        int numberOfSets = dataSets.length;
        if (!params.getClusterName().equals("batch")) {
            System.out.println("Cluster name: " + params.getClusterName());
            BingoRunner test = new BingoRunner(annParser, descriptor, dataSets[0], params.getClusterName(), params.getFileOutputDir(), numberOfSets);
            test.actionPerformed();
            System.out.println();
        } else {
            ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
            System.out.println("Number of sets: " + numberOfSets);
            for (int i = 0; i < numberOfSets; ++i) {
                String clusterName = dataSets[i].split("\\s+")[0].isEmpty() ? dataSets[i].split("\\s+")[1] : dataSets[i].split("\\s+")[0];
                executorService.execute(new BingoRunner(annParser, descriptor, dataSets[i], clusterName, params.getFileOutputDir(), numberOfSets));
            }
            executorService.shutdown();
            boolean t = true;
            while (t) {
                boolean bMeasure = executorService.isTerminated();
                if (!bMeasure) continue;
                t = false;
            }
        }
        Instant end = Instant.now();
        long execTime = Duration.between(start, end).getSeconds();
        System.out.println();
        System.out.println("Execution time: " + execTime + " s");
    }
}

