/*
 * Decompiled with CFR 0.152.
 */
package configurator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public final class Configurator {
    private Properties properties;
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private String userName;
    private String password;
    private String confFilePath = "./configuration/conf.properties";
    private String logFilePath;
    private String dirFiles;
    private String species = "human";
    private String annotationFileName;
    private String goOntologyFileName;
    private String hpoOntologyFileName;
    private String inheritanceAnnotationFileName;
    private String organAnnotationFileName;
    private String courseAnnotationFileName;
    private String modifierAnnotationFileName;
    private String hpoFullAnnotationFileName;
    private String goConsortiumAddress;
    private String pathToOboFile;
    private String pathToAnnotationFile;
    private String hpOboAddress;
    private String hpAnnotationAddress;
    private String hpPhenotypeAnnotationAddress;
    private String hugoFileAddress;
    private String uniProtFtpAddress;
    private String uniProtByOrganismFolder;
    private String uniprotSwissFastFileFolder;
    private String uniProtMappingFileName;
    private String downloadFolder;
    private String mappingFolder;
    private int port;

    public Configurator() {
        this.init(this.species);
    }

    public Configurator(String species) {
        this.species = species;
        if (OS.contains("win")) {
            String string = this.confFilePath.replace("/", "\\\\");
        }
        this.init(species);
    }

    private void init(String species) {
        this.properties = new Properties();
        try (FileInputStream input = new FileInputStream(this.confFilePath);){
            this.properties.load(input);
            this.userName = this.properties.getProperty("user");
            this.password = this.properties.getProperty("password");
            this.logFilePath = this.properties.getProperty("log_file");
            this.dirFiles = this.properties.getProperty("files_dir");
            this.annotationFileName = this.properties.getProperty(species);
            this.goOntologyFileName = this.properties.getProperty("go_ontology_file");
            this.hpoOntologyFileName = this.properties.getProperty("hpo_ontology_file");
            this.inheritanceAnnotationFileName = this.properties.getProperty("human_I");
            this.courseAnnotationFileName = this.properties.getProperty("human_C");
            this.modifierAnnotationFileName = this.properties.getProperty("human_M");
            this.organAnnotationFileName = this.properties.getProperty("human_O");
            this.hpoFullAnnotationFileName = this.properties.getProperty("human_W");
            this.goConsortiumAddress = this.properties.getProperty("gene_ontology_consortium");
            this.pathToOboFile = this.properties.getProperty("go_obo_folder");
            this.pathToAnnotationFile = this.properties.getProperty("go_annotation_folder");
            this.hpOboAddress = this.properties.getProperty("hpo_obo");
            this.hpAnnotationAddress = this.properties.getProperty("hpo_annotation");
            this.hpPhenotypeAnnotationAddress = this.properties.getProperty("hpo_phenotype_annotation");
            this.hugoFileAddress = this.properties.getProperty("hugo_mapping_file");
            this.uniProtFtpAddress = this.properties.getProperty("uniprot_link");
            this.uniProtByOrganismFolder = this.properties.getProperty("uniprot_mapping_files");
            this.mappingFolder = this.properties.getProperty("mapping_folder");
            this.uniProtMappingFileName = this.properties.getProperty(species + "_uni");
            this.downloadFolder = this.properties.getProperty("download_folder");
            this.uniprotSwissFastFileFolder = this.properties.getProperty("uniprot_swiss_prot");
            this.port = Integer.parseInt(this.properties.getProperty("port"));
        }
        catch (IOException ex) {
            Logger.getLogger("configuration").info(ex.getMessage());
        }
    }

    public void createDiNGOFolders() {
        boolean bValue;
        File downloadFolderLocal = new File(this.downloadFolder);
        File annotationFolder = new File(this.dirFiles);
        File mappingFolderLocal = new File(this.mappingFolder);
        if (!downloadFolderLocal.exists()) {
            bValue = downloadFolderLocal.mkdir();
            if (bValue) {
                System.out.println("Folder " + downloadFolderLocal.getName() + " has been created!");
            } else {
                System.out.println("");
            }
        }
        if (!annotationFolder.exists() && (bValue = annotationFolder.mkdir())) {
            System.out.println("Folder " + annotationFolder.getName() + " has been created!");
        }
        if (!mappingFolderLocal.exists() && (bValue = mappingFolderLocal.mkdir())) {
            System.out.println("Folder " + mappingFolderLocal.getName() + " has been created!");
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConFilePath() {
        return this.confFilePath;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public String getDirFiles() {
        return this.dirFiles;
    }

    public String getSpecies() {
        return this.species;
    }

    public String getAnnotationFileName() {
        return this.annotationFileName;
    }

    public String getGoOntologyFileName() {
        return this.goOntologyFileName;
    }

    public String getHpoOntologyFileName() {
        return this.hpoOntologyFileName;
    }

    public String getInheritanceAnnotationFileName() {
        return this.inheritanceAnnotationFileName;
    }

    public String getOrganAnnotationFileName() {
        return this.organAnnotationFileName;
    }

    public String getCourseAnnotationFileName() {
        return this.courseAnnotationFileName;
    }

    public String getModifierAnnotationFileName() {
        return this.modifierAnnotationFileName;
    }

    public String getHpoFullAnnotationFileName() {
        return this.hpoFullAnnotationFileName;
    }

    public boolean isSpeciesSupported(String sp) {
        return this.properties.containsKey(sp);
    }

    public String getPathToOboFile() {
        return this.pathToOboFile;
    }

    public String getGoConsortiumAddress() {
        return this.goConsortiumAddress;
    }

    public String getPathToAnnotationFile() {
        return this.pathToAnnotationFile;
    }

    public String getHpOboAddress() {
        return this.hpOboAddress;
    }

    public String getHpAnnotationAddress() {
        return this.hpAnnotationAddress;
    }

    public String getHpPhenotypeAnnotationAddress() {
        return this.hpPhenotypeAnnotationAddress;
    }

    public String getDownloadFolder() {
        return this.downloadFolder;
    }

    public String getHugoFileAddress() {
        return this.hugoFileAddress;
    }

    public String getMappingFolder() {
        return this.mappingFolder;
    }

    public String getUniProtFtpAddress() {
        return this.uniProtFtpAddress;
    }

    public String getUniProtByOrganismFolder() {
        return this.uniProtByOrganismFolder;
    }

    public String getUniProtMappingFileName() {
        return this.uniProtMappingFileName;
    }

    public String getUniprotSwissFastFileFolder() {
        return this.uniprotSwissFastFileFolder;
    }

    public int getPort() {
        return this.port;
    }
}

