/*
 * Decompiled with CFR 0.152.
 */
package bingo;

import bingo.BinomialDistribution;
import bingo.CalculateTestTask;
import bingo.DistributionCount;
import bingo.HypergeometricDistribution;
import bingo.IDistribution;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class StatisticTestCalculate
extends CalculateTestTask {
    private Map<Integer, Integer> mapSmallN;
    private Map<Integer, Integer> mapSmallX;
    private Map<Integer, Integer> mapBigN;
    private Map<Integer, Integer> mapBigX;
    private Map<Integer, String> statisticTestMap;
    private String distributionType;
    private boolean isOver;

    public StatisticTestCalculate(DistributionCount dc, String distributionType, boolean isOver) {
        dc.calculate();
        this.mapSmallN = dc.getMapSmallN();
        this.mapSmallX = dc.getMapSmallX();
        this.mapBigN = dc.getMapBigN();
        this.mapBigX = dc.getMapBigX();
        this.distributionType = distributionType;
        this.isOver = isOver;
    }

    @Override
    public void calculate() {
        this.statisticTestMap = new HashMap<Integer, String>();
        HashSet<Integer> set = new HashSet<Integer>(this.mapSmallX.keySet());
        Iterator<Integer> iterator = set.iterator();
        while (iterator.hasNext()) {
            IDistribution hd;
            Integer id = new Integer(iterator.next().toString());
            Integer smallXvalue = this.mapSmallX.get(id);
            Integer smallNvalue = this.mapSmallN.get(id);
            Integer bigXvalue = this.mapBigX.get(id);
            Integer bigNvalue = this.mapBigN.get(id);
            if (this.distributionType.equalsIgnoreCase("Hypergeometric test")) {
                hd = new HypergeometricDistribution(smallXvalue, bigXvalue, smallNvalue, bigNvalue, this.isOver);
            } else if (this.distributionType.equalsIgnoreCase("Binomial test")) {
                hd = new BinomialDistribution(smallXvalue, bigXvalue, smallNvalue, bigNvalue, this.isOver);
            } else {
                throw new IllegalArgumentException("Supported tests:\n1. Hypergeometric test\n2. Binomial test\n");
            }
            this.statisticTestMap.put(id, hd.calculateDistribution());
        }
    }

    @Override
    public Map<Integer, String> getTestMap() {
        return this.statisticTestMap;
    }

    @Override
    Map<Integer, Integer> getMapSmallX() {
        return this.mapSmallX;
    }

    @Override
    Map<Integer, Integer> getMapSmallN() {
        return this.mapSmallN;
    }

    @Override
    Map<Integer, Integer> getMapBigX() {
        return this.mapBigX;
    }

    @Override
    Map<Integer, Integer> getMapBigN() {
        return this.mapBigN;
    }
}

