/*
 * Decompiled with CFR 0.152.
 */
package bingo;

import bingo.DistributionCount;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ontology.Annotation;
import ontology.Ontology;

public class StandardDistributionCount
extends DistributionCount {
    private Annotation annotation;
    private Map<String, HashSet<String>> alias;
    private Set<String> selectedNodes;
    private Set<String> refNodes;
    private Map<Integer, Integer> mapSmallN;
    private Map<Integer, Integer> mapSmallX;
    private Map<Integer, Integer> mapBigN;
    private Map<Integer, Integer> mapBigX;
    private boolean isOver = true;

    public StandardDistributionCount(Annotation annotation, Ontology ontology, Set<String> selectedNodes, Set<String> refNodes, Map<String, HashSet<String>> alias) {
        this.annotation = annotation;
        this.alias = alias;
        annotation.setOntology(ontology);
        this.selectedNodes = selectedNodes;
        this.refNodes = refNodes;
    }

    public StandardDistributionCount(Annotation annotation, Ontology ontology, Set<String> selectedNodes, Set<String> refNodes, Map<String, HashSet<String>> alias, boolean isOver) {
        this.annotation = annotation;
        this.alias = alias;
        annotation.setOntology(ontology);
        this.selectedNodes = selectedNodes;
        this.refNodes = refNodes;
        this.isOver = isOver;
    }

    @Override
    public void calculate() {
        this.countSmallX();
        this.countSmallN();
        this.countBigX();
        this.countBigN();
    }

    @Override
    public HashSet<String> getNodeClassifications(String node) {
        HashSet<String> classifications = new HashSet<String>();
        Set identifiers = this.alias.get(node);
        if (identifiers != null) {
            Iterator it = identifiers.iterator();
            while (it.hasNext()) {
                int[] goID = this.annotation.getClassifications(String.valueOf(it.next()));
                for (int t = 0; t < goID.length; ++t) {
                    classifications.add("" + goID[t]);
                }
            }
        }
        return classifications;
    }

    public HashSet<String> getAllClassifications() {
        HashSet<String> classifications = new HashSet<String>();
        Iterator<String> i = this.refNodes.iterator();
        while (i.hasNext()) {
            Set identifiers = this.alias.get(String.valueOf(i.next()));
            if (identifiers == null) continue;
            Iterator it = identifiers.iterator();
            while (it.hasNext()) {
                int[] goID = this.annotation.getClassifications(String.valueOf(it.next()));
                for (int t = 0; t < goID.length; ++t) {
                    classifications.add("" + goID[t]);
                }
            }
        }
        return classifications;
    }

    @Override
    public void countSmallN() {
        this.mapSmallN = this.count(this.refNodes);
    }

    @Override
    public void countSmallX() {
        this.mapSmallX = this.count(this.selectedNodes);
    }

    @Override
    public Map<Integer, Integer> count(Set<String> nodes) {
        Integer id;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        if (!this.isOver) {
            HashSet<String> allClassifications = this.getAllClassifications();
            Iterator<String> iterator1 = allClassifications.iterator();
            while (iterator1.hasNext()) {
                id = Integer.parseInt(iterator1.next());
                if (map.containsKey(id)) continue;
                map.put(id, 0);
            }
        }
        Iterator<String> i = nodes.iterator();
        while (i.hasNext()) {
            Set classifications = this.getNodeClassifications(i.next());
            Iterator iterator = ((HashSet)classifications).iterator();
            while (iterator.hasNext()) {
                id = Integer.parseInt((String)iterator.next());
                if (map.containsKey(id)) {
                    map.put(id, map.get(id) + 1);
                    continue;
                }
                if (!this.isOver) continue;
                map.put(id, 1);
            }
        }
        return map;
    }

    @Override
    public void countBigN() {
        this.mapBigN = new HashMap<Integer, Integer>();
        int bigN = this.refNodes.size();
        Iterator<String> i = this.refNodes.iterator();
        while (i.hasNext()) {
            Set classifications = this.getNodeClassifications(i.next().toString());
            Iterator iterator = ((HashSet)classifications).iterator();
            if (iterator.hasNext()) continue;
            --bigN;
        }
        for (Integer id : this.mapSmallX.keySet()) {
            this.mapBigN.put(id, bigN);
        }
    }

    @Override
    public void countBigX() {
        this.mapBigX = new HashMap<Integer, Integer>();
        int bigX = this.selectedNodes.size();
        Iterator<String> i = this.selectedNodes.iterator();
        while (i.hasNext()) {
            Set classifications = this.getNodeClassifications(i.next().toString());
            Iterator iterator = ((HashSet)classifications).iterator();
            if (iterator.hasNext()) continue;
            --bigX;
        }
        for (Integer id : this.mapSmallX.keySet()) {
            this.mapBigX.put(id, bigX);
        }
    }

    public Map getTestMap() {
        return this.mapSmallX;
    }

    @Override
    public Map<Integer, Integer> getMapSmallN() {
        return this.mapSmallN;
    }

    @Override
    public Map<Integer, Integer> getMapSmallX() {
        return this.mapSmallX;
    }

    @Override
    public Map<Integer, Integer> getMapBigN() {
        return this.mapBigN;
    }

    @Override
    public Map<Integer, Integer> getMapBigX() {
        return this.mapBigX;
    }
}

