/*
 * Decompiled with CFR 0.152.
 */
package bingo;

import bingo.AnnotationParser;
import bingo.CalculateCorrectionTask;
import bingo.CalculateTestTask;
import bingo.Constants;
import bingo.Pair;
import bingo.StatisticsDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ontology.Annotation;
import ontology.Ontology;

public final class CreateBiNGOFile {
    private Map<Integer, String> testMap;
    private Map<String, String> correctionMap;
    private Map<Integer, Integer> mapSmallX;
    private Map<Integer, Integer> mapSmallN;
    private Map<Integer, Integer> mapBigX;
    private Map<Integer, Integer> mapBigN;
    private String alphaString;
    private String testString;
    private String correctionString;
    private String overUnderString;
    private String ontologyType;
    private String namespace;
    private Annotation annotation;
    private Set<String> deleteCodes;
    private Ontology ontology;
    private String annotationFile;
    private String ontologyFile;
    private String dirName;
    private String fileName;
    private String clusterVsString;
    private String catString;
    private Set<String> selectedCanonicalNameVector;
    private Set<String> noClassificationsSet;
    private Map<String, HashSet<String>> annotatedGenes;
    private Map<String, HashSet<String>> alias;

    public CreateBiNGOFile(CalculateTestTask test, CalculateCorrectionTask correctionTest, AnnotationParser parser, StatisticsDescriptor descriptor, Set<String> selectedNodes, Set<String> noClassificationsSet, String outputDir, String clusterName, String category) {
        this.testMap = test.getTestMap();
        if (correctionTest != null) {
            this.correctionMap = correctionTest.getCorrectionMap();
        }
        this.mapSmallX = test.getMapSmallX();
        this.mapSmallN = test.getMapSmallN();
        this.mapBigX = test.getMapBigX();
        this.mapBigN = test.getMapBigN();
        this.alphaString = descriptor.getpValue();
        this.annotation = parser.getAnnotation();
        this.ontology = parser.getOntology();
        this.annotationFile = parser.getAnnotationFile();
        this.ontologyFile = parser.getOntologyFile();
        this.testString = descriptor.getTest();
        this.correctionString = descriptor.getCorrectionTest();
        this.overUnderString = descriptor.getRepresentation();
        this.dirName = outputDir;
        this.fileName = clusterName + ".bgo";
        this.clusterVsString = descriptor.getReferenceSet();
        this.catString = category;
        this.selectedCanonicalNameVector = selectedNodes;
        this.noClassificationsSet = noClassificationsSet;
        this.annotatedGenes = new HashMap<String, HashSet<String>>();
        this.alias = parser.getAlias();
        this.deleteCodes = parser.getDeleteCodes();
        this.ontologyType = parser.getOntologyType();
        this.namespace = parser.getNamespace();
    }

    private void loadAnnotatedGenes() {
        Iterator<String> it = this.selectedCanonicalNameVector.iterator();
        while (it.hasNext()) {
            String name = it.next();
            HashSet<String> tmp = this.alias.get(name);
            if (tmp == null) continue;
            Iterator<String> it2 = tmp.iterator();
            while (it2.hasNext()) {
                int[] nodeClassifications = this.annotation.getClassifications(String.valueOf(it2.next()));
                for (int k = 0; k < nodeClassifications.length; ++k) {
                    String cat = Integer.toString(nodeClassifications[k]);
                    if (!this.annotatedGenes.containsKey(cat)) {
                        HashSet catset = new HashSet();
                        this.annotatedGenes.put(cat, catset);
                    }
                    this.annotatedGenes.get(cat).add(name);
                }
            }
        }
    }

    private void writeHeaderToFile(PrintWriter output) {
        String dateString = DateFormat.getDateInstance().format(new Date());
        String timeString = DateFormat.getTimeInstance().format(new Date());
        output.println("File created with dingo (c) on " + dateString + " at " + timeString);
        output.println();
        output.println(this.ontology.toString());
        output.println();
        output.println("Selected ontology file : " + this.ontologyFile);
        output.println("Selected annotation file : " + this.annotationFile);
        output.println("Selected namespace: " + this.namespace);
        output.println("Discarded evidence codes : ");
        Iterator<String> it = this.deleteCodes.iterator();
        while (it.hasNext()) {
            output.write(it.next().toString() + "\t");
        }
        output.println("Selected statistical test : " + this.testString);
        output.println("Selected correction : " + this.correctionString);
        output.println("Selected significance level : " + this.alphaString);
        output.println("Testing option : " + this.clusterVsString);
        output.println("Representation: " + this.overUnderString);
        output.println("The following " + this.noClassificationsSet.size() + " entities have no annotations:");
        output.println(this.noClassificationsSet.toString().replace("[", "").replace("]", "").replace(", ", "|"));
        output.println("\n\n\n\n" + this.ontologyType + "-ID\tp-value\tcorr p-value\tx\tn\tX\tN\tDescription\tGenes in test set");
    }

    public void writeToFile() {
        this.loadAnnotatedGenes();
        File results = new File(this.dirName, this.fileName);
        try (PrintWriter writer = new PrintWriter(results);){
            this.writeHeaderToFile(writer);
            ArrayList<Pair<Integer>> pairs = new ArrayList<Pair<Integer>>();
            for (Map.Entry<Integer, String> entry : this.testMap.entrySet()) {
                pairs.add(new Pair<Integer>(entry.getKey(), entry.getValue()));
            }
            pairs.sort(new Comparator<Pair<Integer>>(){

                @Override
                public int compare(Pair<Integer> o1, Pair<Integer> o2) {
                    return new BigDecimal(o1.getValue()).compareTo(new BigDecimal(o2.getValue()));
                }
            });
            Iterator it = pairs.iterator();
            while (it.hasNext()) {
                StringBuilder line = new StringBuilder();
                Pair pair = (Pair)it.next();
                Integer key = (Integer)pair.getKey();
                String value = pair.getValue();
                if (this.catString.equals(Constants.CATEGORY_BEFORE_CORRECTION.getConstant())) {
                    if (new BigDecimal(this.testMap.get(key)).compareTo(new BigDecimal(this.alphaString)) < 0) {
                        correctedPValue = this.correctionMap == null ? "-" : String.format("%6.3e", Double.parseDouble(this.correctionMap.get(Integer.toString(key))));
                        line.append(key).append("\t").append(String.format("%6.3e", Double.parseDouble(value))).append("\t").append(correctedPValue).append("\t").append(this.mapSmallX.get(key)).append("\t").append(this.mapSmallN.get(key)).append("\t").append(this.mapBigX.get(key)).append("\t").append(this.mapBigN.get(key)).append("\t").append(this.ontology.getTerm(key).getName()).append("\t").append(this.annotatedGenes.get(Integer.toString(key)).toString().replace("[", "").replace("]", "").replace(", ", "|"));
                    }
                } else {
                    String comp;
                    correctedPValue = this.correctionMap == null ? "-" : String.format("%6.3e", Double.parseDouble(this.correctionMap.get(Integer.toString(key))));
                    String string = comp = this.correctionMap == null ? this.testMap.get(key) : this.correctionMap.get(Integer.toString(key));
                    if (new BigDecimal(comp).compareTo(new BigDecimal(this.alphaString)) < 0) {
                        line.append(key).append("\t").append(String.format("%6.3e", Double.parseDouble(value))).append("\t").append(correctedPValue).append("\t").append(this.mapSmallX.get(key)).append("\t").append(this.mapSmallN.get(key)).append("\t").append(this.mapBigX.get(key)).append("\t").append(this.mapBigN.get(key)).append("\t").append(this.ontology.getTerm(key).getName()).append("\t").append(this.annotatedGenes.get(Integer.toString(key)).toString().replace("[", "").replace("]", "").replace(", ", "|"));
                    }
                }
                if (line.toString().length() == 0) continue;
                writer.println(line.toString());
            }
        }
        catch (IOException ex) {
            System.out.println("Unable to write to file!");
        }
    }
}

