/*
 * Decompiled with CFR 0.152.
 */
package bingo;

import bingo.IDistribution;
import cern.jet.stat.Probability;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BinomialDistribution
implements IDistribution {
    private int x;
    private int bigX;
    private int n;
    private int bigN;
    private double p;
    private boolean isOver = true;
    private static final int SCALE_RESULT = 100;

    public BinomialDistribution(int x, int bigX, int n, int bigN) {
        this.x = x;
        this.bigX = bigX;
        this.n = n;
        this.bigN = bigN;
        this.p = (double)n * 1.0 / (double)bigN;
    }

    public BinomialDistribution(int x, int bigX, int n, int bigN, boolean isOver) {
        this.x = x;
        this.bigX = bigX;
        this.n = n;
        this.bigN = bigN;
        this.p = (double)n * 1.0 / (double)bigN;
        this.isOver = isOver;
    }

    private String calculateBinomialDistribution() {
        double tmp = this.isOver ? Probability.binomialComplemented(this.x - 1, this.bigX, this.p) : Probability.binomial(this.x, this.bigX, this.p);
        BigDecimal sum = new BigDecimal(tmp);
        return sum.toString();
    }

    private BigDecimal decimalPow(BigDecimal x, BigInteger pow) {
        if (pow.equals(new BigInteger("0"))) {
            return new BigDecimal("1");
        }
        BigDecimal product = x;
        BigInteger i = new BigInteger("1");
        while (!i.equals(pow)) {
            product = product.multiply(x);
            i = i.add(new BigInteger("1"));
        }
        return product.setScale(100, 4);
    }

    @Override
    public String calculateDistribution() {
        return this.calculateBinomialDistribution();
    }
}

