/*
 * Decompiled with CFR 0.152.
 */
package bingo;

import bingo.Constants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class BingoParameters {
    private String clusterName;
    private String textInput;
    private String test;
    private String overOrUnder = "Overrepresentation";
    private String correctionTest;
    private BigDecimal significance;
    private String category;
    private String referenceSet;
    private String species;
    private String annotationFile;
    private String ontologyFile;
    private String mappingFile;
    private String namespace = "O";
    private Set<String> deleteCodes = new HashSet<String>();
    private String fileOutputDir = "./";
    private String ontologyName = "GO";
    private String inputFileName;
    private int numberOfUsedCores = 1;

    public BingoParameters(String[] argumentsValues) {
        this.category = Constants.CATEGORY_CORRECTION.getConstant();
        this.test = Constants.HYPERGEOMETRIC.getConstant();
        this.correctionTest = Constants.BENJAMINI_HOCHBERG_FDR.getConstant();
        this.referenceSet = Constants.GENOME.getConstant();
        this.significance = new BigDecimal("0.05");
        this.initParameters(argumentsValues);
        this.getInputFromFile();
    }

    private void initParameters(String[] args) {
        int len = args.length;
        for (int i = 0; i < len - 1; ++i) {
            if (args[i].equals("-o")) {
                this.clusterName = args[i + 1];
            }
            if (args[i].equals("-i")) {
                this.inputFileName = args[i + 1];
                if (!new File(this.inputFileName).exists()) {
                    throw new IllegalArgumentException("File " + this.inputFileName + " does not exist!");
                }
            }
            if (args[i].equals("-r")) {
                switch (args[i + 1]) {
                    case "1": {
                        this.overOrUnder = "Overrepresentation";
                        break;
                    }
                    case "2": {
                        this.overOrUnder = "Underrepresentation";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("After -r flag one the following values can be expected:\n1 - over-representation\n2 - under-representation\nFound value " + args[i + 1] + "!\n");
                    }
                }
            }
            if (args[i].equals("-c")) {
                switch (args[i + 1]) {
                    case "1": {
                        this.category = Constants.CATEGORY_BEFORE_CORRECTION.getConstant();
                        break;
                    }
                    case "2": {
                        this.category = Constants.CATEGORY_CORRECTION.getConstant();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The category argument (-c flag) can take the following values:\n \n1 - Overrepresented categories after correction\n 2 - Overrepresented categories before correction\nFound value: " + args[i + 1]);
                    }
                }
            }
            if (args[i].equals("-st")) {
                switch (args[i + 1]) {
                    case "1": {
                        this.test = Constants.HYPERGEOMETRIC.getConstant();
                        break;
                    }
                    case "2": {
                        this.test = Constants.BINOMIAL.getConstant();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Flag -st allowed values:\n1 - Hypergeometric test\n2 - Binomial test\nFound value: " + args[i + 1]);
                    }
                }
            }
            if (args[i].equals("-ct")) {
                switch (args[i + 1]) {
                    case "1": {
                        this.correctionTest = Constants.BENJAMINI_HOCHBERG_FDR.getConstant();
                        break;
                    }
                    case "2": {
                        this.correctionTest = Constants.BONFERRONI.getConstant();
                        break;
                    }
                    case "3": {
                        this.correctionTest = Constants.NONE.getConstant();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Flag -ct allowed values:\n1 - Benjamini & Hochberg False Discovery Rate (FDR) correction\n2 - Bonferroni\n3 - No correction\nFound value: " + args[i + 1]);
                    }
                }
            }
            if (args[i].equals("-rs")) {
                this.referenceSet = args[i + 1].equals("1") ? Constants.GENOME.getConstant() : args[i + 1];
            }
            if (args[i].equals("-of")) {
                this.ontologyFile = args[i + 1];
                if (!new File(this.ontologyFile).exists()) {
                    throw new IllegalArgumentException("File " + this.ontologyFile + " does not exist!");
                }
            }
            if (args[i].equals("-ns")) {
                this.namespace = args[i + 1].toUpperCase();
            }
            if (args[i].equals("-af")) {
                this.annotationFile = args[i + 1];
                if (!new File(this.annotationFile).exists()) {
                    throw new IllegalArgumentException("File " + this.annotationFile + " does not exist!");
                }
            }
            if (args[i].equals("-dc")) {
                this.deleteCodes = new HashSet<String>(Arrays.asList(args[i + 1].split(":")));
            }
            if (args[i].equals("-sf")) {
                this.fileOutputDir = args[i + 1];
                File file = new File(this.fileOutputDir);
                if (!file.exists()) {
                    System.out.println("Folder " + file.getAbsolutePath() + " has not been found!\nCreating the folder...");
                    boolean isMade = file.mkdir();
                    if (isMade) {
                        System.out.println("The folder has been created!");
                    } else {
                        System.out.println("Creation of folder " + String.valueOf(file) + " failed! Create folder manually and run application again!");
                        throw new IllegalArgumentException("");
                    }
                }
            }
            if (args[i].equals("-p")) {
                this.significance = new BigDecimal(args[i + 1]);
                if (this.significance.compareTo(new BigDecimal(1)) > 0 || this.significance.compareTo(new BigDecimal(0)) < 0) {
                    throw new IllegalArgumentException("p value must be in the following range 0 \u2264 p \u2264 1");
                }
            }
            if (args[i].equals("-t")) {
                try {
                    this.numberOfUsedCores = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException ex) {
                    System.out.println(args[i + 1] + " is not an integer!");
                    throw new IllegalArgumentException("Number of threads must be an integer");
                }
            }
            if (args[i].equals("-s")) {
                this.species = args[i + 1];
            }
            if (args[i].equals("-e")) {
                this.ontologyName = args[i + 1];
            }
            if (args[i].equals("-m")) {
                this.mappingFile = args[i + 1];
            }
            if (!args[i].equals("-h")) continue;
            BingoParameters.getHelp();
        }
        if (this.getNamespaceFullName().equals("unspecified")) {
            throw new IllegalArgumentException("Unknown namespace " + this.namespace);
        }
        if (this.ontologyName.equalsIgnoreCase("HPO")) {
            this.species = "human";
        }
        if (this.ontologyName.equalsIgnoreCase("GO") && (this.namespace.equals("O") || this.namespace.equals("I") || this.namespace.equals("M") || this.namespace.equals("C") || this.namespace.equals("F"))) {
            throw new IllegalArgumentException("GO does not contain  subontology " + this.namespace + " (" + this.getNamespaceFullName() + ")");
        }
        if (this.ontologyName.equalsIgnoreCase("HPO") && (this.namespace.equals("BP") || this.namespace.equals("CC") || this.namespace.equals("MF"))) {
            throw new IllegalArgumentException("HPO does not contain  subontology " + this.namespace + " (" + this.getNamespaceFullName() + ")");
        }
        this.namespace = this.getNamespaceFullName();
    }

    private String getNamespaceFullName() {
        return switch (this.namespace) {
            case "P" -> "phenotypic_abnormality";
            case "I" -> "mode_of_inheritance";
            case "M" -> "clinical_modifier";
            case "C" -> "clinical_course";
            case "F" -> "frequency";
            case "MF" -> "molecular_function";
            case "BP" -> "biological_process";
            case "CC" -> "cellular_component";
            case "W" -> "---";
            default -> "unspecified";
        };
    }

    public static void getHelp() {
        System.out.println("Usage:");
        System.out.println("    java -jar DiNGO.jar [options]\n");
        System.out.println("Options:");
        System.out.printf("%-30s%s%n", "    -o <oFile>", "Output file name\n");
        System.out.printf("%-30s%s%n", "    -i <iFile>", "Input file containing list of genes/proteins\n");
        System.out.printf("%-30s%s%n", "    -r <representation>", "Over or under [default: over]\n");
        System.out.printf("%-30s%s%n", "    -c <category>", "1 category before correction");
        System.out.printf("%-30s%s%n", "                 ", "2 category after correction [default: 2]\n");
        System.out.printf("%-30s%s%n", "    -st <statistical test>", "1 hypergeometric");
        System.out.printf("%-30s%s%n", "                          ", "2 binomial [default: 1]\n");
        System.out.printf("%-30s%s%n", "    -rs <reference set>", "1 whole annotation");
        System.out.printf("%-30s%s%n", "                       ", "custom reference set [default: 1]\n");
        System.out.printf("%-30s%s%n", "    -ns <namespace>", "P phenotypic abnormality (HPO)");
        System.out.printf("%-30s%s%n", "                   ", "I mode of inheritance (HPO)");
        System.out.printf("%-30s%s%n", "                   ", "M clinical modifier (HPO)");
        System.out.printf("%-30s%s%n", "                   ", "C clinical course (HPO)");
        System.out.printf("%-30s%s%n", "                   ", "MF molecular function (GO)");
        System.out.printf("%-30s%s%n", "                   ", "BP biological process (GO)");
        System.out.printf("%-30s%s%n", "                   ", "CC cellular_component (GO)");
        System.out.printf("%-30s%s%n", "                   ", "W all namespaces (GO or HPO)\n");
        System.out.printf("%-30s%s%n", "    -of <ontology file>", "File in obo or flat file format [default: DiNGO default obo file]\n");
        System.out.printf("%-30s%s%n", "    -af <annotation file>", "Requires gaf or flat file format [default: DiNGO default annotation file]\n");
        System.out.printf("%-30s%s%n", "    -dc <delete codes>", "Evidence codes\n");
        System.out.printf("%-30s%s%n", "    -sf <folder>", "Folder where results will be saved [default: ./]\n");
        System.out.printf("%-30s%s%n", "    -p <significance level>", "Defines threshold value [default: 0.05]\n");
        System.out.printf("%-30s%s%n", "    -e <name of ontology>", "HPO or GO [default: GO]\n");
        System.out.printf("%-30s%s%n", "    -t <number of threads>", "Number of threads (works only for batch mode) [default: 1]\n");
        System.out.printf("%-30s%s%n", "    -s <species>", "Name of species\n");
        System.out.printf("%-30s%s%n", "    -m <mapping file>", "TAB delimited file containing IDs\n");
        System.out.printf("%-30s%s%n", "    -h", "Prints this help");
    }

    private void getInputFromFile() {
        StringBuilder inputB = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.inputFileName));){
            String input;
            while ((input = reader.readLine()) != null) {
                inputB.append(input.replace("\n", "").replace("\t", "").replace("\r", "").replace(" ", "_")).append(" ");
            }
            this.textInput = inputB.toString().trim();
        }
        catch (IOException msg) {
            System.out.println(msg.getMessage());
        }
    }

    public int getNumberOfUsedCores() {
        return this.numberOfUsedCores;
    }

    public Set<String> getDeleteCodes() {
        return this.deleteCodes;
    }

    public String getTextInput() {
        return this.textInput;
    }

    public String getSpecies() {
        return this.species;
    }

    public String getOverOrUnder() {
        return this.overOrUnder;
    }

    public String getCategory() {
        return this.category;
    }

    public String getReferenceSet() {
        return this.referenceSet;
    }

    public String getAnnotationFile() {
        return this.annotationFile;
    }

    public String getOntologyFile() {
        return this.ontologyFile;
    }

    public String getNameSpace() {
        return this.namespace;
    }

    public String getFileOutputDir() {
        return this.fileOutputDir;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getTest() {
        return this.test;
    }

    public String getCorrectionTest() {
        return this.correctionTest;
    }

    public String getOntologyName() {
        return this.ontologyName;
    }

    public BigDecimal getSignificance() {
        return this.significance;
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    public void setAnnotationFile(String annotationFile) {
        this.annotationFile = annotationFile;
    }

    public void setOntologyFile(String ontologyFile) {
        this.ontologyFile = ontologyFile;
    }
}

