/*
 * Decompiled with CFR 0.152.
 */
package bingo;

import bingo.BenjaminiHochbergFDR;
import bingo.Bonferroni;
import bingo.CalculateCorrectionTask;
import bingo.CalculateTestTask;
import bingo.Constants;
import bingo.StandardDistributionCount;
import bingo.StatisticTestCalculate;
import bingo.StatisticsDescriptor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ontology.Annotation;
import ontology.Ontology;

public class BingoAlgorithm {
    private StatisticsDescriptor descriptor;
    private Map<String, HashSet<String>> alias;
    private Set<String> selectedNodes;
    private Set<String> allNodes;
    private Annotation annotation;
    private Ontology ontology;

    public BingoAlgorithm(Annotation annotation, Ontology ontology, StatisticsDescriptor descriptor, Map<String, HashSet<String>> alias, Set<String> selectedNodes, Set<String> allNodes) {
        this.annotation = annotation;
        this.ontology = ontology;
        this.descriptor = descriptor;
        this.alias = alias;
        this.selectedNodes = selectedNodes;
        this.allNodes = allNodes;
    }

    public CalculateTestTask calculate_distribution() {
        boolean isOver = this.descriptor.getRepresentation().equals(Constants.OVERSTRING.getConstant());
        StatisticTestCalculate test = new StatisticTestCalculate(new StandardDistributionCount(this.annotation, this.ontology, this.selectedNodes, this.allNodes, this.alias, isOver), this.descriptor.getTest(), isOver);
        return test;
    }

    public CalculateCorrectionTask calculate_corrections(Map testMap) {
        CalculateCorrectionTask correction = null;
        if (!this.descriptor.getCorrectionTest().equals(Constants.NONE.getConstant())) {
            if (this.descriptor.getCorrectionTest().equals(Constants.BONFERRONI.getConstant())) {
                correction = new Bonferroni(testMap);
            } else if (this.descriptor.getCorrectionTest().equals(Constants.BENJAMINI_HOCHBERG_FDR.getConstant())) {
                try {
                    correction = new BenjaminiHochbergFDR(testMap);
                }
                catch (NullPointerException ex) {
                    correction = null;
                }
            } else {
                Object var2_4 = null;
            }
        }
        return correction;
    }
}

