/*
 * Decompiled with CFR 0.152.
 */
package bingo;

import bingo.IOntologyReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ontology.Ontology;
import ontology.OntologyTerm;

public class BiNGOOntologyFlatFileReader
implements IOntologyReader {
    Ontology ontology;
    String curator = "unknown";
    String ontologyType = "unknown";
    String filename;
    Map<Integer, Integer> synonymHash;
    Map<String, Integer> goMap;

    public BiNGOOntologyFlatFileReader(File file) throws IllegalArgumentException, IOException, Exception {
        this(file.getPath());
    }

    public BiNGOOntologyFlatFileReader(String filename) throws IllegalArgumentException, IOException, Exception {
        this.filename = filename;
        this.synonymHash = new HashMap<Integer, Integer>();
        this.goMap = new HashMap<String, Integer>();
        this.parse();
    }

    private int stringToInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private void parseHeader(String firstLine) throws Exception {
        String[] tokens = firstLine.split("\\)");
        Object errorMsg = "error in OntologyFlatFileReader.parseHeader ().\n";
        errorMsg = (String)errorMsg + "First line of " + this.filename + " must have form:\n";
        errorMsg = (String)errorMsg + "   (curator=GO) (type=all) \n";
        errorMsg = (String)errorMsg + "instead found:\n";
        errorMsg = (String)errorMsg + "   " + firstLine + "\n";
        if (tokens.length != 2) {
            throw new IllegalArgumentException((String)errorMsg);
        }
        String[] curatorRaw = tokens[0].split("=");
        if (curatorRaw.length != 2) {
            throw new IllegalArgumentException((String)errorMsg);
        }
        this.curator = curatorRaw[1].trim();
        String[] typeRaw = tokens[1].split("=");
        if (typeRaw.length != 2) {
            throw new IllegalArgumentException((String)errorMsg);
        }
        this.ontologyType = typeRaw[1].trim();
    }

    private void updateSynonyms(String value, int id) {
        String name;
        int firstLeftBracket = value.indexOf("[isa: ");
        if (firstLeftBracket < 0) {
            firstLeftBracket = value.indexOf("[partof: ");
        }
        String string = name = firstLeftBracket < 0 ? value.substring(0).trim() : value.substring(0, firstLeftBracket);
        if (!this.goMap.containsKey(name)) {
            this.goMap.put(name, id);
        }
        this.synonymHash.put(id, this.goMap.get(name));
    }

    private void parse() throws Exception {
        this.ontology = new Ontology(this.curator, this.ontologyType);
        try (BufferedReader reader = new BufferedReader(new FileReader(this.filename));){
            String line;
            boolean isHeader = true;
            while ((line = reader.readLine()) != null) {
                String[] allMarkers;
                String rawMarker;
                if (isHeader) {
                    this.parseHeader(line);
                    isHeader = false;
                    continue;
                }
                int equals = line.indexOf("=");
                String idString = line.substring(0, equals).trim();
                int id = this.stringToInt(idString);
                String value = line.substring(equals + 1);
                int firstLeftBracket = value.indexOf("[isa: ");
                OntologyTerm term = null;
                if (firstLeftBracket < 0) {
                    firstLeftBracket = value.indexOf("[partof: ");
                    markerEnd = value.indexOf("]", firstLeftBracket);
                    rawMarker = value.substring(firstLeftBracket + 9, markerEnd).trim();
                    name = value.substring(0).trim();
                    if (!this.ontology.containsTerm(this.synonymHash.get(id))) {
                        term = new OntologyTerm(name, this.synonymHash.get(id));
                        this.ontology.add(term);
                    }
                } else {
                    markerEnd = value.indexOf("]", firstLeftBracket);
                    rawMarker = value.substring(firstLeftBracket + 6, markerEnd).trim();
                    name = value.substring(0, firstLeftBracket).trim();
                    term = new OntologyTerm(name, this.synonymHash.get(id));
                    this.ontology.add(term);
                }
                for (String marker : allMarkers = rawMarker.split(" ")) {
                    if (term == null) continue;
                    term.addParent(this.synonymHash.get(this.stringToInt(marker)));
                }
                this.updateSynonyms(value, id);
            }
        }
        catch (IOException ex) {
            System.out.println("Unable to read ontology file " + this.filename);
        }
    }

    @Override
    public Ontology getOntology() {
        return this.ontology;
    }

    @Override
    public Map<Integer, Integer> getSynonymHash() {
        return this.synonymHash;
    }
}

