/*
 * Decompiled with CFR 0.152.
 */
package bingo;

import bingo.IAnnotation;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ontology.Annotation;

public class BiNGOConsortiumAnnotationReader
implements IAnnotation {
    private Annotation annotation;
    private String annotationType;
    private String species;
    private String curator;
    private String filename;
    private Map<Integer, Integer> synonymHash;
    private HashMap<String, HashSet<String>> alias;
    private Set<String> deleteCodes;
    private boolean orphansFound = false;
    private boolean consistency = false;

    public BiNGOConsortiumAnnotationReader(String filename, String mappingFile, Map<Integer, Integer> synonymHash, Set<String> deleteCodes, String annotationType, String curator) {
        this.filename = filename;
        this.species = filename;
        this.annotationType = annotationType;
        this.curator = curator;
        this.synonymHash = synonymHash;
        this.deleteCodes = deleteCodes;
        this.parse();
        if (mappingFile != null) {
            this.retrieveAlias(mappingFile);
        }
    }

    private int stringToInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private void updateAlias(String valuef, String values) {
        if (this.alias.containsKey(valuef)) {
            this.alias.get(valuef).add(values);
        } else {
            HashSet<String> tmp = new HashSet<String>();
            tmp.add(values);
            this.alias.put(valuef, tmp);
        }
    }

    private void parse() {
        this.annotation = new Annotation(this.species, this.annotationType, this.curator);
        this.alias = new HashMap();
        HashSet<Integer> orphans = new HashSet<Integer>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.filename));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] aliases;
                String[] tokens;
                String evidenceCode;
                if (line.startsWith("!") || this.deleteCodes.contains(evidenceCode = (tokens = line.split("\t"))[6].trim().toUpperCase())) continue;
                String primaryID = tokens[1].trim().toUpperCase();
                this.updateAlias(primaryID, primaryID);
                String secondaryID = tokens[2].trim().toUpperCase();
                this.updateAlias(secondaryID, primaryID);
                for (String alias1 : aliases = tokens[10].split("\\|")) {
                    this.updateAlias(alias1, primaryID);
                }
                String goID = tokens[4].trim().toUpperCase().substring(3);
                int id = this.stringToInt(goID);
                Integer id2 = id;
                Integer mainId = this.synonymHash.get(id2);
                if (mainId != null) {
                    if (primaryID.length() != 0 && id != -1) {
                        this.annotation.add(primaryID, mainId);
                    }
                    this.consistency = true;
                    continue;
                }
                orphans.add(id2);
                this.orphansFound = true;
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void retrieveAlias(String fileName) {
        try (BufferedReader reader = new BufferedReader(new FileReader(fileName));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] fields;
                for (String f : fields = line.trim().split("\\t")) {
                    if (this.alias.containsKey(f)) {
                        HashSet<String> temp = this.alias.get(f);
                        temp.addAll(Arrays.asList(fields));
                        this.alias.put(f, temp);
                        continue;
                    }
                    this.alias.put(f, new HashSet<String>(Arrays.asList(fields)));
                }
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public boolean getOrphans() {
        return this.orphansFound;
    }

    @Override
    public boolean getConsistency() {
        return this.consistency;
    }

    public HashMap<String, HashSet<String>> getAlias() {
        return this.alias;
    }
}

