/*
 * Decompiled with CFR 0.152.
 */
package bingo;

import bingo.BiNGOAnnotationFlatFileReader;
import bingo.BiNGOConsortiumAnnotationReader;
import bingo.BiNGOOntologyFlatFileReader;
import bingo.BiNGOOntologyOboReader;
import bingo.Constants;
import bingo.IAnnotation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ontology.Annotation;
import ontology.Ontology;
import ontology.OntologyTerm;

public class AnnotationParser {
    private static final String LOADCORRECT = "LOADCORRECT";
    private String ontologyType = "GO";
    private final String ontologyFile;
    private final String annotationFile;
    private final String mappingFile;
    private final String namespace;
    private Annotation annotation;
    private Annotation parsedAnnotation;
    private Ontology ontology;
    private Map<String, HashSet<String>> alias;
    private Ontology fullOntology;
    private Map<Integer, Integer> synonymHash;
    private final Set<String> genes;
    private final Set<String> deleteCodes;
    private boolean status = true;
    private boolean orphansFound = false;
    private boolean consistency = false;
    private Set<Integer> parentsSet;

    public AnnotationParser(Set<String> genes, Set<String> deleteCodes, String ontologyFile, String annotationFile, String namespace, String mappingFile) {
        this.genes = genes;
        this.deleteCodes = deleteCodes;
        this.ontologyFile = ontologyFile;
        this.annotationFile = annotationFile;
        this.namespace = namespace;
        this.mappingFile = mappingFile;
    }

    public void calculate() throws IOException {
        String loadOntologyString = this.setOntology();
        if (this.ontologyFile.endsWith(".obo")) {
            if (!loadOntologyString.equals(LOADCORRECT)) {
                this.status = false;
                System.out.println("Your full ontology file contains errors " + loadOntologyString);
            }
            if (this.status) {
                this.checkOntology(this.fullOntology);
            }
        }
        if (this.status) {
            if (!loadOntologyString.equals(LOADCORRECT)) {
                this.status = false;
                System.out.println("Your ontology file contains errors " + loadOntologyString);
            }
            if (this.status) {
                this.checkOntology(this.ontology);
                if (this.status) {
                    String loadAnnotationString = this.setAnnotation();
                    if (!loadAnnotationString.equals(LOADCORRECT)) {
                        this.status = false;
                        System.out.println("Your annotation file contains errors " + loadAnnotationString);
                    }
                    if (this.status && !this.consistency) {
                        this.status = false;
                        throw new IOException("None of the labels in your annotation match with the chosen ontology, please check their compatibility.");
                    }
                    if (this.status) {
                        this.remap();
                    }
                }
            }
        }
    }

    private String setAnnotation() {
        Object resultString;
        String fileString = this.annotationFile;
        this.annotation = null;
        try {
            IAnnotation readerAnnotation = fileString.contains("gene_association") || fileString.contains("phenotype_annotation") || fileString.endsWith(".gaf") ? new BiNGOConsortiumAnnotationReader(fileString, this.mappingFile, this.synonymHash, this.deleteCodes, "Consortium", "GO") : new BiNGOAnnotationFlatFileReader(fileString, this.mappingFile, this.synonymHash);
            this.annotation = readerAnnotation.getAnnotation();
            if (readerAnnotation.getOrphans()) {
                this.orphansFound = true;
            }
            if (readerAnnotation.getConsistency()) {
                this.consistency = true;
            }
            this.alias = readerAnnotation.getAlias();
            resultString = LOADCORRECT;
        }
        catch (IllegalArgumentException e) {
            resultString = "ANNOTATION FILE PARSING ERROR, PLEASE CHECK FILE FORMAT:  \n" + String.valueOf(e);
        }
        catch (Exception e) {
            resultString = String.valueOf(e);
        }
        return resultString;
    }

    private String setOntology() {
        Object resultString;
        String fileString = this.ontologyFile;
        this.ontology = null;
        this.fullOntology = null;
        try {
            this.synonymHash = null;
            if (fileString.endsWith(".obo")) {
                BiNGOOntologyOboReader readerOntology = new BiNGOOntologyOboReader(fileString, this.namespace);
                if (!this.namespace.equals(Constants.NONE.getConstant())) {
                    BiNGOOntologyOboReader full = new BiNGOOntologyOboReader(fileString, Constants.NONE.getConstant());
                    this.fullOntology = full.getOntology();
                    this.synonymHash = full.getSynonymHash();
                } else {
                    this.fullOntology = readerOntology.getOntology();
                    this.synonymHash = readerOntology.getSynonymHash();
                }
                this.ontology = readerOntology.getOntology();
                this.ontologyType = readerOntology.getOntologyType();
            } else {
                BiNGOOntologyFlatFileReader readerOntology = new BiNGOOntologyFlatFileReader(fileString);
                this.ontology = readerOntology.getOntology();
                this.synonymHash = readerOntology.getSynonymHash();
            }
            if (this.ontology.size() == 0 || this.fullOntology != null && this.fullOntology.size() == 0) {
                throw new IllegalArgumentException();
            }
            resultString = LOADCORRECT;
        }
        catch (IllegalArgumentException e) {
            resultString = "ONTOLOGY FILE PARSING ERROR, PLEASE CHECK FILE FORMAT AND VALIDITY OF NAMESPACE:  \n" + String.valueOf(e);
        }
        catch (IOException e) {
            resultString = "Ontology file could not be located...";
        }
        catch (Exception e) {
            resultString = String.valueOf(e);
        }
        return resultString;
    }

    private void checkOntology(Ontology ontology) throws IOException {
        HashMap<Integer, OntologyTerm> ontMap = ontology.getTerms();
        Iterator<Integer> it = ontMap.keySet().iterator();
        while (it.hasNext()) {
            this.parentsSet = new HashSet<Integer>();
            int childNode = Integer.parseInt(it.next().toString());
            this.up_go(childNode, childNode, ontology);
        }
    }

    private void remap() {
        this.parsedAnnotation = new Annotation(this.annotation.getSpecies(), this.annotation.getType(), this.annotation.getCurator());
        HashMap<String, ArrayList<Integer>> annMap = this.annotation.getMap();
        Iterator<String> it = annMap.keySet().iterator();
        HashSet ids = new HashSet();
        for (String gene : this.genes) {
            if (this.alias.get(gene) == null) continue;
            ids.addAll(this.alias.get(gene));
        }
        while (it.hasNext()) {
            this.parentsSet = new HashSet<Integer>();
            String node = String.valueOf(it.next());
            if (!this.genes.isEmpty() && !ids.contains(node)) continue;
            int[] goID = this.annotation.getClassifications(node);
            for (int t = 0; t < goID.length; ++t) {
                if (this.ontology.getTerm(goID[t]) != null) {
                    this.parsedAnnotation.add(node, goID[t]);
                }
                if (this.ontologyFile.endsWith(".obo")) {
                    if (this.fullOntology.getTerm(goID[t]) != null) {
                        this.up(node, goID[t], this.parsedAnnotation, this.ontology, this.fullOntology);
                        continue;
                    }
                    System.out.println("Orphan found " + goID[t]);
                    this.orphansFound = true;
                    continue;
                }
                this.up(node, goID[t], this.parsedAnnotation, this.ontology, this.ontology);
            }
        }
    }

    private void up(String node, int id, Annotation parsedAnnotation, Ontology ontology, Ontology flOntology) {
        OntologyTerm child = flOntology.getTerm(id);
        int[] parents = child.getParentsAndContainers();
        for (int t = 0; t < parents.length; ++t) {
            if (this.parentsSet.contains(parents[t])) continue;
            this.parentsSet.add(parents[t]);
            if (ontology.getTerm(parents[t]) != null) {
                parsedAnnotation.add(node, parents[t]);
            }
            this.up(node, parents[t], parsedAnnotation, ontology, flOntology);
        }
    }

    private void up_go(int startID, int id, Ontology ontology) throws IOException {
        OntologyTerm child = ontology.getTerm(id);
        int[] parents = child.getParentsAndContainers();
        for (int t = 0; t < parents.length; ++t) {
            if (parents[t] == startID) {
                this.status = false;
                throw new IOException("Your ontology file contains a cycle at ID " + startID);
            }
            if (this.parentsSet.contains(parents[t])) continue;
            if (ontology.getTerm(parents[t]) != null) {
                this.parentsSet.add(parents[t]);
                this.up_go(startID, parents[t], ontology);
                continue;
            }
            System.out.println("term not in ontology: " + parents[t]);
        }
    }

    public Annotation getAnnotation() {
        return this.parsedAnnotation;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public Map<String, HashSet<String>> getAlias() {
        return this.alias;
    }

    public String getOntologyType() {
        return this.ontologyType;
    }

    public boolean getOrphans() {
        return this.orphansFound;
    }

    public boolean getStatus() {
        return this.status;
    }

    public String getOntologyFile() {
        return this.ontologyFile;
    }

    public String getAnnotationFile() {
        return this.annotationFile;
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Set<String> getDeleteCodes() {
        return this.deleteCodes;
    }
}

